<?php
/*--------------------------------------------------------------
   Text.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field;
use Webmozart\Assert\Assert;

class Text implements Field
{
    /**
     * @var string
     */
    private $name;
    
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $name, string $value)
    {
        Assert::stringNotEmpty($name);
        Assert::stringNotEmpty($value);
        
        $this->name  = $name;
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $name, string $value): self
    {
        return new self($name, $value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function name(): string
    {
        return $this->name;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): string
    {
        return $this->value;
    }
}